--SQL itself has also been enhanced over the years to include
--LOGIC functions

--such as CASE
/* Show me the monthly revenue
   If the revenue is less than categorise it as red
   If it is between and categorise it as orange
   If it is greater than categorise it as green */
SELECT datename(month,[date]) as month
       ,sum(sale_price*quantity_sold) as revenue
	   ,CASE WHEN sum(sale_price*quantity_sold) <14000000 THEN 'Red'
	         WHEN sum(sale_price*quantity_sold) <16000000 THEN 'Orange'
			 ELSE 'Green'
		END as KPI
FROM sales_2017
GROUP BY datename(month,[date]),datepart(month,[date])
ORDER BY datepart(month,[date])

--and COALESCE
/* Show me all the sales for '2016-01-02'
   Replace any nulls with a zero */
SELECT [date],product_code,sale_price--,quantity_sold
	   ,coalesce(quantity_sold,0) as quantity_sold
FROM sales_2016
WHERE date = '2016-01-02'